package sk.kosice.konto.kkmessageservice.message;

import static sk.kosice.konto.kkmessageservice.restapi.common.ObjectMapperHelper.createJsonNodeListFromString;

import java.util.List;
import java.util.UUID;
import sk.kosice.konto.kkmessageservice.domain.common.enumeration.BodyType;
import sk.kosice.konto.kkmessageservice.domain.common.enumeration.Location;
import sk.kosice.konto.kkmessageservice.restapi.dto.message.ImmutableMessageCreateRequest;

public final class MessageApiFixtures {

  private static final String ACTIONS_JSON =
      """
    [
            {
              "title": "1. Platba kartou online",
              "desc": "Najrýchlejší spôsob, ako zaplatiť miestnu daň, je priamo cez elektronickú platobnú bránu mesta. Pre rýchlu platbu kliknite na tlačidlo „Zaplať kartou“. Platba bude spracovaná okamžite.",
              "type": "OPEN_PAY_BY_CARD_URL",
              "value": "/pay/metadata",
              "metadata": [
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c8",
                  "type": "text",
                  "key": "Platba za:",
                  "value": "miestnu daň z nehnuteľnosti"
                },
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c4",
                  "type": "price",
                  "key": "Suma:",
                  "value": "150.00"
                },
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c3",
                  "type": "text",
                  "key": "VARIABILNY_SYMBOL",
                  "value": "150.00"
                },
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c2",
                  "type": "text",
                  "key": "IBAN",
                  "value": "SK3112000000198742637541"
                }
              ]
            },
            {
              "title": "2. Platba bankovým prevodom alebo PAY by square",
              "desc": "Využite možnosť úhrady prostredníctvom svojho internet bankingu \\nalebo rýchlejšiu cestu skenovaním QR kódu nižšie.             \\n",
              "type": "SHOW_PAY_QR_CODE",
              "value": "",
              "metadata": [
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c8",
                  "type": "text",
                  "key": "TITLE",
                  "value": "Platobné údaje:"
                },
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c9",
                  "type": "text",
                  "key": "Platba za:",
                  "value": "miestnu daň z nehnuteľnosti"
                },
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c7",
                  "type": "price",
                  "key": "Suma:",
                  "value": "150.00"
                },
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c6",
                  "type": "text",
                  "key": "VARIABILNY_SYMBOL",
                  "value": "150.00"
                },
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c5",
                  "type": "text",
                  "key": "IBAN",
                  "value": "SK3112000000198742637541"
                }
              ]
            }
          ]
    """;

  public static ImmutableMessageCreateRequest createMessageRequest(UUID topicId) {
    return ImmutableMessageCreateRequest.builder()
        .title("title")
        .topicId(topicId)
        .bodyType(BodyType.TEXT)
        .body("body")
        .bodyShort("bodyShort")
        .tags(createJsonNodeListFromString("[{\"a\":\"b\"},{\"c\":\"d\"}]"))
        .build();
  }

  public static ImmutableMessageCreateRequest createMessageRequestWithActions(UUID topicId) {
    return ImmutableMessageCreateRequest.builder()
        .title("title")
        .topicId(topicId)
        .bodyType(BodyType.TEXT)
        .body("body")
        .bodyShort("bodyShort")
        .tags(createJsonNodeListFromString("[{\"a\":\"b\"},{\"c\":\"d\"}]"))
        .actions(createJsonNodeListFromString(ACTIONS_JSON))
        .addAllLocations(
            List.of(Location.KOSICE_BARCA, Location.KOSICE_STARO_MESTO, Location.KOSICE_DZUNGLA))
        .build();
  }
}
