package sk.kosice.konto.kkmessageservice.topic;

import static org.assertj.core.api.Assertions.assertThat;
import static sk.kosice.konto.kkmessageservice.repository.model.Tables.TOPIC;
import static sk.kosice.konto.kkmessageservice.topic.TopicApiFixtures.createTopicRequest;

import org.junit.jupiter.api.Test;

public class TopicOrganizationNameSynchronizeFeatureSpec extends TopicFeatureSpec {

  @Test
  public void thatOrganizationNameCanBeChecked() {
    final var topic1 = createTopic(ORGANIZATION_ID_1, createTopicRequest("o1_t1"));
    final var topic2 = createTopic(ORGANIZATION_ID_1, createTopicRequest("o1_t2"));
    final var topic3 = createTopic(ORGANIZATION_ID_2, createTopicRequest());

    prepareUpdatedOrganizationListResponse();

    synchronizeTopicOrganizationNameUseCase.execute();
    final var dbRecords = dslContext.selectFrom(TOPIC).fetch();

    final var updatedTopic1 =
        dbRecords.stream().filter(t -> t.getId().equals(topic1.getId())).findFirst().get();
    final var updatedTopic2 =
        dbRecords.stream().filter(t -> t.getId().equals(topic2.getId())).findFirst().get();
    final var updatedTopic3 =
        dbRecords.stream().filter(t -> t.getId().equals(topic3.getId())).findFirst().get();

    assertThat(updatedTopic1.getOrganizationName()).isEqualTo("updatedOrganizationName1");
    assertThat(updatedTopic2.getOrganizationName()).isEqualTo("updatedOrganizationName1");
    assertThat(updatedTopic3.getOrganizationName()).isEqualTo("updatedOrganizationName2");
  }
}
