package sk.kosice.konto.kkmessageservice.business.message.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import sk.kosice.konto.kkmessageservice.business.AbstractService;
import sk.kosice.konto.kkmessageservice.business.message.port.inbound.FindMessageByIdAsOrganizationUseCase;
import sk.kosice.konto.kkmessageservice.business.message.port.outbound.QueryMessagePort;
import sk.kosice.konto.kkmessageservice.business.organization.port.outbound.QueryOrganizationPort;
import sk.kosice.konto.kkmessageservice.domain.message.entity.MessageEntity;
import sk.kosice.konto.kkmessageservice.domain.message.query.FindMessageByIdAndOrganizationIdQuery;

@Named
public class FindMessageByIdAsOrganizationService extends AbstractService
    implements FindMessageByIdAsOrganizationUseCase {

  private final QueryMessagePort queryMessagePort;
  private final QueryOrganizationPort queryOrganizationPort;

  @Inject
  public FindMessageByIdAsOrganizationService(
      QueryMessagePort queryMessagePort, QueryOrganizationPort queryOrganizationPort) {
    this.queryMessagePort = queryMessagePort;
    this.queryOrganizationPort = queryOrganizationPort;
  }

  @Override
  public MessageEntity execute(FindMessageByIdAndOrganizationIdQuery query) {
    queryOrganizationPort.findOne(query.organizationId());

    return queryMessagePort.findOne(query);
  }
}
