package sk.kosice.konto.kkmessageservice.business.message.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import sk.kosice.konto.kkmessageservice.business.AbstractService;
import sk.kosice.konto.kkmessageservice.business.message.port.inbound.FindMessageByIdAsRecipientUseCase;
import sk.kosice.konto.kkmessageservice.business.message.port.outbound.QueryMessagePort;
import sk.kosice.konto.kkmessageservice.domain.message.entity.MessageEntity;
import sk.kosice.konto.kkmessageservice.domain.message.query.FindMessageByIdAndKidQuery;

@Named
public class FindMessageByIdAsRecipientService extends AbstractService
    implements FindMessageByIdAsRecipientUseCase {

  private final QueryMessagePort queryMessagePort;

  @Inject
  public FindMessageByIdAsRecipientService(QueryMessagePort queryMessagePort) {
    this.queryMessagePort = queryMessagePort;
  }

  @Override
  public MessageEntity execute(FindMessageByIdAndKidQuery query) {
    return queryMessagePort.findOne(query);
  }
}
