package sk.kosice.konto.kkmessageservice.business.permission.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.UUID;
import sk.kosice.konto.kkmessageservice.business.AbstractService;
import sk.kosice.konto.kkmessageservice.business.businessconfig.BusinessConfigProvider;
import sk.kosice.konto.kkmessageservice.business.organization.port.outbound.QueryOrganizationPort;
import sk.kosice.konto.kkmessageservice.business.permission.port.outbound.CheckPermissionsUseCase;
import sk.kosice.konto.kkmessageservice.domain.permission.command.CheckPermissionCommand;

@Named
public class CheckPermissionsService extends AbstractService implements CheckPermissionsUseCase {

  private final QueryOrganizationPort queryOrganizationPort;
  private final BusinessConfigProvider businessConfigProvider;

  @Inject
  public CheckPermissionsService(
      QueryOrganizationPort queryOrganizationPort, BusinessConfigProvider businessConfigProvider) {
    this.queryOrganizationPort = queryOrganizationPort;
    this.businessConfigProvider = businessConfigProvider;
  }

  @Override
  public Boolean execute(CheckPermissionCommand command) {
    final var userOrganizationIds = queryOrganizationPort.getUserGroupIds(command.actorId());

    final var acceptedRoles =
        command.permissionToCheck().getRoles().stream()
            .map(
                role ->
                    UUID.fromString(
                        businessConfigProvider.getBusinessConfig().getRoleIdByName(role)))
            .distinct()
            .toList();

    // Fist condition is for checking if user has permission to action via role.
    // Second condition is for checking if user has permission to specific organization.
    return userOrganizationIds.stream()
            .filter(o -> acceptedRoles.contains(o) || o.equals(command.actionGroupId()))
            .count()
        >= 2;
  }
}
