package sk.kosice.konto.kkmessageservice.business.subscription.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import sk.kosice.konto.kkmessageservice.business.AbstractService;
import sk.kosice.konto.kkmessageservice.business.subscription.port.inbound.BatchDeleteSubscriptionByOrganizationIdAndKidUseCase;
import sk.kosice.konto.kkmessageservice.business.subscription.port.outbound.PersistSubscriptionPort;
import sk.kosice.konto.kkmessageservice.domain.subscription.command.DeleteSubscriptionsByOrganizationIdAndKidCommand;
import sk.kosice.konto.kkmessageservice.domain.subscription.data.ImmutableDeleteSubscriptionsByOrganizationIdAndKidData;

@Named
public class BatchDeleteSubscriptionByOrganizationIdAndKidService extends AbstractService
    implements BatchDeleteSubscriptionByOrganizationIdAndKidUseCase {

  private final PersistSubscriptionPort persistSubscriptionPort;

  @Inject
  public BatchDeleteSubscriptionByOrganizationIdAndKidService(
      PersistSubscriptionPort persistSubscriptionPort) {
    this.persistSubscriptionPort = persistSubscriptionPort;
  }

  @Override
  public void execute(DeleteSubscriptionsByOrganizationIdAndKidCommand command) {

    persistSubscriptionPort.batchDeleteByOrganizationIdAndKid(
        ImmutableDeleteSubscriptionsByOrganizationIdAndKidData.builder()
            .recipientKid(command.recipientKid())
            .rsqlQuery(command.rsqlQuery())
            .build());
  }
}
