package sk.kosice.konto.kkmessageservice.domain.common.listing;

import sk.kosice.konto.kkmessageservice.domain.common.listing.common.ListingAttribute;

public enum MessageListingAttribute implements ListingAttribute {
  TITLE("title", false, true),
  BODY("body", false, true),
  CREATED_AT("createdAt", true, false),
  TOPIC_ID("topicId", false, true),
  TOPIC_NAME("topicName", false, true);

  private final String apiName;
  private final boolean forSorting;
  private final boolean forFiltering;
  private final boolean isTranslated;

  MessageListingAttribute(String apiName, boolean forSorting, boolean forFiltering) {
    this(apiName, forSorting, forFiltering, false);
  }

  MessageListingAttribute(
      String apiName, boolean forSorting, boolean forFiltering, boolean isTranslated) {
    this.apiName = apiName;
    this.forSorting = forSorting;
    this.forFiltering = forFiltering;
    this.isTranslated = isTranslated;
  }

  @Override
  public String apiName() {
    return apiName;
  }

  @Override
  public boolean isForSorting() {
    return forSorting;
  }

  @Override
  public boolean isForFiltering() {
    return forFiltering;
  }

  @Override
  public Boolean isTranslated() {
    return isTranslated;
  }
}
