package sk.kosice.konto.kkmessageservice.repository.rsql.jooq.builder.error;

import sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCode;
import sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType;

public enum JooqTranslationsBuilderErrorCode implements ErrorCode {
  NO_COLUMN_CONFIGURED(
      ErrorCodeType.INTERNAL, "No table column configured for attribute with name '%s'.");

  final String template;
  final ErrorCodeType type;

  JooqTranslationsBuilderErrorCode(ErrorCodeType type, String template) {
    this.template = template;
    this.type = type;
  }

  @Override
  public String template() {
    return template;
  }

  @Override
  public ErrorCodeType type() {
    return type;
  }
}
