package sk.kosice.konto.kkmessageservice.repository.subscription;

import java.util.List;
import java.util.UUID;
import sk.kosice.konto.kkmessageservice.domain.common.listing.PageSize;
import sk.kosice.konto.kkmessageservice.domain.subscription.data.DeleteSubscriptionsByOrganizationIdAndKidData;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.BaseSubscriptionEntity;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.ImmutableBaseSubscriptionEntity;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.ListOfSubscriptions;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.SubscriptionEntity;
import sk.kosice.konto.kkmessageservice.domain.subscription.query.ImmutableSubscriptionListingQuery;

public interface JooqSubscriptionRepositoryTestSupport {

  default BaseSubscriptionEntity prepareSubscriptionUpdateEntity(UUID id) {
    return ImmutableBaseSubscriptionEntity.builder().id(id).isEmailEnabled(true).build();
  }

  default void updateSubscriptionsBatch(
      JooqSubscriptionRepository repository, List<BaseSubscriptionEntity> updateData) {
    repository.batchUpdate(updateData);
  }

  default void updateSubscription(
      JooqSubscriptionRepository repository, BaseSubscriptionEntity updateData) {
    repository.update(updateData);
  }

  default List<SubscriptionEntity> findSubscriptions(
      JooqSubscriptionRepository repository, UUID recipientKid) {
    return repository.listWithoutPaging(
        ImmutableSubscriptionListingQuery.builder()
            .pageSize(PageSize.of(10, 10))
            .recipientKid(recipientKid)
            .build());
  }

  default ListOfSubscriptions listSubscriptions(
      JooqSubscriptionRepository repository, UUID recipientKid) {
    return repository.list(
        ImmutableSubscriptionListingQuery.builder()
            .pageSize(PageSize.of(10, 10))
            .recipientKid(recipientKid)
            .build());
  }

  default void deleteSubscriptionsByOrganizationIdAndKid(
      JooqSubscriptionRepository subscriptionRepository,
      DeleteSubscriptionsByOrganizationIdAndKidData data) {
    subscriptionRepository.batchDeleteByOrganizationIdAndKid(data);
  }
}
