package sk.kosice.konto.kkmessageservice.restapi.mapper;

import sk.kosice.konto.kkmessageservice.domain.permission.entity.ListOfPermissions;
import sk.kosice.konto.kkmessageservice.restapi.dto.permission.ImmutablePermissionDto;
import sk.kosice.konto.kkmessageservice.restapi.dto.permission.ImmutablePermissionListResponse;
import sk.kosice.konto.kkmessageservice.restapi.dto.permission.PermissionListResponse;

public class PermissionResponseMapper {

  public static PermissionListResponse map(ListOfPermissions entities) {
    final var permissions =
        entities.items().entrySet().stream()
            .map(
                e ->
                    ImmutablePermissionDto.builder()
                        .organization(OrganizationResponseMapper.map(e.getKey()))
                        .addAllPermissions(e.getValue())
                        .build())
            .toList();

    return ImmutablePermissionListResponse.builder()
        .totalCount(permissions.size())
        .addAllItems(permissions)
        .build();
  }
}
