import React from 'react';
import EmptyIllustration from '@/assets/empty_illustration.svg';

interface EmptyProps {
  title: string;
  description?: string;
  img?: React.ReactNode;
}

const Empty: React.FC<EmptyProps> = ({ title, description, img = <EmptyIllustration className="w-24 tb2:w-32" /> }) => (
  <div className="flex flex-col items-center justify-center text-center mb-5">
    {img}
    <h4 className="mt-5">{title}</h4>
    {!!description && <p className="text-txt-grey idsk-text-body mt-2">{description}</p>}
  </div>
);

export default Empty;
