import React from 'react';
import { ErrorImg, PrimaryButton } from '@/lib/idsk';
import { SessionError as SessionErrorType } from '@/utils';
import Link from 'next/link';

interface SessionErrorProps {
  error: SessionErrorType;
}

const genericTitle = 'Pri prihlásení nastala chyba';
const genericMessage =
  'Niektoré údaje sa nepodarilo načítať a aplikácia nemusí fungovať správne. Skúste sa odhlásiť a následne sa znovu prihláste.';

const MAP: Record<SessionErrorType, { title: string; message: string }> = {
  OrganizationError: {
    title: 'Nepodarilo sa načítať údaje o organizácii',
    message: genericMessage
  },
  NoOrganizationError: {
    title: 'Nemáte práva na žiadnu organizáciu ani mestskú časť.',
    message:
      'Kontaktujte administrátora s požiadavkou o pridelenie do niektorej z organizácií alebo mestských častí mesta Košice.'
  },
  MissingTokenError: {
    title: 'Chýbajúce autentifikačné tokeny',
    message: genericMessage
  },
  RefreshTokenError: {
    title: 'Vaša relácia vypršala',
    message: 'Platnosť vašej relácie vypršala a musíte sa znovu prihlásiť.'
  }
};

const SessionError: React.FC<SessionErrorProps> = ({ error }) => {
  const title = MAP[error]?.title || genericTitle;
  const message = MAP[error]?.message || genericMessage;

  return (
    <div className="w-full h-full flex flex-col items-center justify-center">
      <div className="max-w-[36rem] flex flex-col items-center justify-center text-center gap-3 idsk-text-body">
        <ErrorImg className="max-w-32" />
        <h3>{title}</h3>
        <p>{message}</p>
        {error === 'RefreshTokenError' && (
          <Link href="/signin" className="mt-4">
            <PrimaryButton>Prihlásiť sa</PrimaryButton>
          </Link>
        )}
      </div>
    </div>
  );
};

export default SessionError;
