import { AxiosResponse } from 'axios';
import { getRequestError } from './error';

export const api = {
  profile: (kid: string) => `/v1/kk/profiles/${kid}`,
  messages: (organizationId: string) => `/v1/kkmessage/organizations/${organizationId}/messages`,
  messagesKid: (kid: string) => `/v1/kkmessage/recipients/${kid}/messages`,
  messageDetail: (organizationId: string, messageId: string) =>
    `/v1/kkmessage/organizations/${organizationId}/messages/${messageId}`,
  organizations: () => `/v1/kkmessage/organizations`,
  organizationsByOid: (oid: string) => `/v1/kkmessage/employees/${oid}/permissions`,
  topics: (organizationId: string) => `/v1/kkmessage/organizations/${organizationId}/topics`,
  topicsDetail: (organizationId: string, topicId: string) =>
    `/v1/kkmessage/organizations/${organizationId}/topics/${topicId}`
};

export const unwrap = async <T>(promise: Promise<AxiosResponse<T>>): Promise<T> => {
  try {
    const response = await promise;
    return response.data;
  } catch (err) {
    throw getRequestError(err);
  }
};
