import { RGB } from './types';

export const date = (timestamp: number | string, locale = 'sk'): string => {
  const d = new Date(timestamp);

  const selectedLocale = locale === 'sk' ? 'sk-SK' : 'en-US';

  const slovakDate = d.toLocaleDateString(selectedLocale, {
    year: 'numeric',
    month: '2-digit',
    day: '2-digit'
  });

  return slovakDate.replaceAll(' ', '');
};

export const hexToRgb = (hex: string): RGB => {
  const hexColor = hex.replace(/^#/, '');
  const bigint = parseInt(hexColor, 16);
  // eslint-disable-next-line no-bitwise
  return { r: (bigint >> 16) & 255, g: (bigint >> 8) & 255, b: bigint & 255 };
};

export const overlayColor = (baseColor: RGB, overlayPercentage: number): RGB => {
  const overlay = Math.min(100, Math.max(-100, overlayPercentage));
  const alpha = Math.abs(overlay) / 100;
  const overlayRgbColor = overlay >= 0 ? { r: 255, g: 255, b: 255 } : { r: 0, g: 0, b: 0 };

  const newR = baseColor.r * (1 - alpha) + overlayRgbColor.r * alpha;
  const newG = baseColor.g * (1 - alpha) + overlayRgbColor.g * alpha;
  const newB = baseColor.b * (1 - alpha) + overlayRgbColor.b * alpha;

  return { r: newR, g: newG, b: newB };
};

export const rgbToString = (color: RGB) => `rgb(${color.r}, ${color.g}, ${color.b})`;
