package sk.kosice.konto.kknotificationservice.restapi.command;

import java.util.Optional;
import java.util.UUID;
import sk.kosice.konto.kknotificationservice.domain.common.ImmutableActorIdentity;
import sk.kosice.konto.kknotificationservice.domain.recipient.command.ImmutableCreateOrUpdateRecipientCommand;
import sk.kosice.konto.kknotificationservice.restapi.dto.recipient.CreateOrUpdateRecipientRequest;

public final class RecipientCommandFactory {

  public static ImmutableCreateOrUpdateRecipientCommand createOrUpdateRecipientCommand(
      UUID kid, CreateOrUpdateRecipientRequest request, Optional<String> actorId) {
    return ImmutableCreateOrUpdateRecipientCommand.builder()
        .kid(kid)
        .preferredEmail(request.getPreferredEmail())
        .actorId(actorId.map(ImmutableActorIdentity::of))
        .build();
  }
}
