import React, { ChangeEvent, useState } from 'react';
import { useTranslations } from 'next-intl';
import { Checkbox, Dialog, Input, PrimaryButton, SecondaryButton } from '@/lib/idsk';
import { ContactType } from '@/utils';

interface AddContactDialogProps {
  type: ContactType;
  opened: boolean;
  value: string;
  error: boolean;
  handleChange: (event: ChangeEvent<HTMLInputElement>) => void;
  onAdd: (primary: boolean) => void;
  onClose: () => void;
}

const AddContactDialog: React.FC<AddContactDialogProps> = ({
  type,
  opened,
  value,
  error,
  handleChange,
  onAdd,
  onClose
}) => {
  const t = useTranslations('my_data');
  const [isPrimary, setIsPrimary] = useState<boolean>(false);

  return (
    <Dialog
      title={t(`new_contact_${type}`)}
      opened={opened}
      toggleOpened={onClose}
      primaryButton={
        <PrimaryButton onClick={() => onAdd(isPrimary)} disabled={!!error || !value}>
          {t('add')}
        </PrimaryButton>
      }
      secondaryButton={<SecondaryButton onClick={onClose}>{t('close')}</SecondaryButton>}
      disableClickOutside
    >
      <div className="flex flex-col justify-start w-full tb2:min-w-[42rem]">
        <Input
          label={t(`contact_${type}`)}
          placeholder={t(`placeholder_${type}`)}
          fullWidth
          required
          mandatory
          value={value}
          onChange={handleChange}
          error={!!error}
          errorMsg={t(`error_${type}`)}
        />
        <Checkbox label={t(`set_${type}_as_primary`)} onChange={(e) => setIsPrimary(e.target.checked)} />
      </div>
    </Dialog>
  );
};

export default AddContactDialog;
