import { logger } from '@/lib/pino';
import { axiosClient, baseUrl, headers } from '../../lib/axios/server';
import { api, Profile, Result } from '../api';
import { getRequestError } from '../api/error';
import { retry } from '../functions';

async function fetchUserProfile(kid: string, token: string) {
  return await axiosClient.get<Profile>(`${baseUrl('kk')}${api.profile(kid).replace('/api', '')}`, {
    headers: await headers({ Authorization: `Bearer ${token}` })
  });
}

export async function getProfile(kid: string, token: string): Promise<Result<Profile>> {
  try {
    const response = await retry(() => fetchUserProfile(kid, token), 3);
    return {
      data: response.data,
      error: undefined
    };
  } catch (err: unknown) {
    logger.error(err);
    const error = getRequestError(err);

    return {
      data: undefined,
      status: error.status,
      error
    };
  }
}
