export const download = (blob: Blob, filename: string) => {
  const link = document.createElement('a');
  link.href = URL.createObjectURL(blob);
  link.download = filename;
  link.click();
  URL.revokeObjectURL(link.href);
};

export const replaceExtension = (fileName: string, extension: string) =>
  `${fileName.replace(/\.[^/.]+$/, '')}.${extension}`;

export const retry = async (fn: (...args: any[]) => Promise<any>, retries = 3) => {
  let count = 0;
  let error = null;

  while (count < retries) {
    try {
      const result = await fn();
      return result;
    } catch (err: unknown) {
      count += 1;
      error = err;
    }
  }

  throw error;
};
