package sk.kosice.konto.kkmessageservice.repository.rsql.jooq.builder;

import static sk.kosice.konto.kkmessageservice.repository.rsql.jooq.builder.error.JooqTranslationsBuilderErrorCode.NO_COLUMN_CONFIGURED;

import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.LogicalNode;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jooq.GroupField;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.metadata.JooqColumnInfo;

public class JooqRsqlTranslationsBuilder
    extends JooqRsqlWithListingMetadataBuilder<List<GroupField>> {

  List<String> translatedAttributeNames;

  public JooqRsqlTranslationsBuilder(List<String> translatedAttributeNames) {
    this.translatedAttributeNames = translatedAttributeNames;
  }

  @Override
  public List<GroupField> build(LogicalNode logicalNode) {
    return logicalNode.getChildren().stream().map(this::build).flatMap(List::stream).toList();
  }

  @Override
  public List<GroupField> build(ComparisonNode comparisonNode) {

    final String property = comparisonNode.getSelector();

    final Optional<JooqColumnInfo<?>> maybe = getMetadata().findByName(property);
    if (maybe.isEmpty()) throw NO_COLUMN_CONFIGURED.createError(property).convertToException();

    return translatedAttributeNames.contains(property)
        ? List.of(maybe.get().getField())
        : Collections.emptyList();
  }
}
