package sk.kosice.konto.kkmessageservice.restapi.dto.message;

import static io.swagger.v3.oas.annotations.media.Schema.RequiredMode.REQUIRED;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.UUID;
import org.immutables.value.Value;

@JsonDeserialize(as = ImmutableMessageTopicDto.class)
@JsonSerialize(as = ImmutableMessageTopicDto.class)
@Value.Immutable
public interface MessageTopicDto {
  @Schema(requiredMode = REQUIRED, example = "5f4e4b9d-0b3d-4b3b-8b3b-3b3b3b3b3b3b")
  @NotNull
  UUID getId();

  @Schema(requiredMode = REQUIRED, example = "Košický Magistrát")
  String getName();
}
