package sk.kosice.konto.kkmessageservice.restapi.dto.permission;

import static io.swagger.v3.oas.annotations.media.Schema.RequiredMode.REQUIRED;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.immutables.value.Value;

@JsonSerialize(as = ImmutablePermissionListResponse.class)
@JsonDeserialize(as = ImmutablePermissionListResponse.class)
@Value.Immutable
public interface PermissionListResponse {

  @Schema(requiredMode = Schema.RequiredMode.REQUIRED)
  List<PermissionDto> items();

  @Schema(
      description = "Total count of listed items.",
      format = "integer",
      requiredMode = REQUIRED,
      example = "1")
  Integer totalCount();
}
