package sk.kosice.konto.kkmessageservice.restapi.command;

import java.util.List;
import java.util.UUID;
import sk.kosice.konto.kkmessageservice.domain.common.listing.ListFiltering;
import sk.kosice.konto.kkmessageservice.domain.common.listing.SubscriptionListingAttribute;
import sk.kosice.konto.kkmessageservice.domain.subscription.command.BatchUpdateSubscriptionCommand;
import sk.kosice.konto.kkmessageservice.domain.subscription.command.CreateSubscriptionsByOrganizationIdCommand;
import sk.kosice.konto.kkmessageservice.domain.subscription.command.DeleteSubscriptionsByOrganizationIdAndKidCommand;
import sk.kosice.konto.kkmessageservice.domain.subscription.command.ImmutableBaseSubscriptionCommand;
import sk.kosice.konto.kkmessageservice.domain.subscription.command.ImmutableBatchUpdateSubscriptionCommand;
import sk.kosice.konto.kkmessageservice.domain.subscription.command.ImmutableCreateSubscriptionsByOrganizationIdCommand;
import sk.kosice.konto.kkmessageservice.domain.subscription.command.ImmutableDeleteSubscriptionsByOrganizationIdAndKidCommand;
import sk.kosice.konto.kkmessageservice.domain.subscription.command.ImmutableUpdateSubscriptionCommand;
import sk.kosice.konto.kkmessageservice.domain.subscription.command.UpdateSubscriptionCommand;
import sk.kosice.konto.kkmessageservice.restapi.dto.subscription.SubscriptionBatchUpdateRequest;
import sk.kosice.konto.kkmessageservice.restapi.dto.subscription.SubscriptionCreateByOrganizationIdRequest;
import sk.kosice.konto.kkmessageservice.restapi.dto.subscription.SubscriptionUpdateRequest;

public class SubscriptionCommandFactory {

  public static UpdateSubscriptionCommand map(
      SubscriptionUpdateRequest request, UUID kid, UUID id) {
    return ImmutableUpdateSubscriptionCommand.builder()
        .id(id)
        .isEmailEnabled(request.getIsEmailEnabled())
        .recipientKid(kid)
        .build();
  }

  public static BatchUpdateSubscriptionCommand map(
      List<SubscriptionBatchUpdateRequest> requests, UUID kid) {
    return ImmutableBatchUpdateSubscriptionCommand.builder()
        .recipientKid(kid)
        .addAllSubscriptions(
            requests.stream()
                .map(
                    r ->
                        ImmutableBaseSubscriptionCommand.builder()
                            .id(r.getId())
                            .isEmailEnabled(r.getIsEmailEnabled())
                            .build())
                .toList())
        .build();
  }

  public static DeleteSubscriptionsByOrganizationIdAndKidCommand map(
      UUID kid, ListFiltering<SubscriptionListingAttribute> filter) {
    return ImmutableDeleteSubscriptionsByOrganizationIdAndKidCommand.builder()
        .recipientKid(kid)
        .rsqlQuery(filter.asOption())
        .build();
  }

  public static CreateSubscriptionsByOrganizationIdCommand map(
      UUID kid, SubscriptionCreateByOrganizationIdRequest request) {
    return ImmutableCreateSubscriptionsByOrganizationIdCommand.builder()
        .recipientKid(kid)
        .addAllOrganizationIds(request.getOrganizations())
        .build();
  }
}
