package sk.kosice.konto.kkmessageservice.config.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;
import sk.kosice.konto.kkmessageservice.idp.config.properties.AzureIdpPropertiesPort;

@Validated
@Configuration(proxyBeanMethods = false)
@ConfigurationProperties(prefix = "sk.kosice.message.azure-idp")
public class AzureIdpPropertiesAdapter implements AzureIdpPropertiesPort {

  private String tenantId;
  private String clientId;
  private String clientSecret;
  private String scopes;

  @Override
  public String tenantId() {
    return tenantId;
  }

  @Override
  public String clientId() {
    return clientId;
  }

  @Override
  public String clientSecret() {
    return clientSecret;
  }

  @Override
  public String scopes() {
    return scopes;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public void setClientId(String clientId) {
    this.clientId = clientId;
  }

  public void setClientSecret(String clientSecret) {
    this.clientSecret = clientSecret;
  }

  public void setScopes(String scopes) {
    this.scopes = scopes;
  }
}
