package sk.kosice.konto.kkmessageservice.subscription;

import static org.assertj.core.api.Assertions.assertThat;
import static sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType.UNAUTHORIZED;
import static sk.kosice.konto.kkmessageservice.repository.model.Tables.SUBSCRIPTION;

import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Test;
import org.springframework.http.HttpStatus;

public class SubscriptionDeleteFeatureSpec extends SubscriptionFeatureSpec {

  @Test
  public void thatSubscriptionsAreDeletedByOrganizationIdAndKid() {
    final List<UUID> topics = prepareTopics();
    prepareRecipient(UUID.fromString(EXTENSION_KID_CLAIM));
    prepareSubscriptions(UUID.fromString(EXTENSION_KID_CLAIM), topics.toArray(UUID[]::new));

    deleteSubscriptionsByOrganizationIdAndKid(
        UUID.fromString(EXTENSION_KID_CLAIM), ORGANIZATION_ID_1, HttpStatus.NO_CONTENT);
    final var subscriptions = dslContext.selectFrom(SUBSCRIPTION).fetch();
    assertThat(subscriptions).isNotNull();
    assertThat(subscriptions).isEmpty();
  }

  @Test
  public void thatSubscriptionsCannotBeDeletedByOrganizationIdAndKidWithoutJwt() {
    final var response =
        deleteSubscriptionsByOrganizationIdAndKidWithoutJwt(
            UUID.randomUUID(), UUID.randomUUID(), HttpStatus.UNAUTHORIZED);

    assertThat(response.primaryFault().get().faultCode()).isEqualTo(UNAUTHORIZED.toString());
  }
}
