package sk.kosice.konto.kkmessageservice.topic;

import static org.assertj.core.api.Assertions.assertThat;
import static sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType.UNAUTHORIZED;
import static sk.kosice.konto.kkmessageservice.domain.topic.error.TopicErrorCode.TOPIC_DOES_NOT_EXIST;
import static sk.kosice.konto.kkmessageservice.topic.TopicApiFixtures.createTopicRequest;

import java.util.UUID;
import org.junit.jupiter.api.Test;
import org.springframework.http.HttpStatus;
import sk.kosice.konto.kkmessageservice.restapi.dto.common.error.ErrorDetailResponse;
import sk.kosice.konto.kkmessageservice.restapi.dto.topic.TopicDetailResponse;

public class TopicDetailFeatureSpec extends TopicFeatureSpec {

  @Test
  public void thatTopicCanBeRetrievedWithEmployeeToken() {
    final var request = createTopicRequest();
    final var created = createTopic(ORGANIZATION_ID_1, request);
    final var detailResponse =
        getTopic(ORGANIZATION_ID_1, created.getId(), HttpStatus.OK, TopicDetailResponse.class);

    assertThat(detailResponse.getId()).isEqualTo(created.getId());
    assertThat(detailResponse.getName()).isEqualTo(created.getName());
    assertThat(detailResponse.getDescription()).isEqualTo(created.getDescription());
    assertThat(detailResponse.getOrganizationId()).isEqualTo(created.getOrganizationId());
  }

  @Test
  public void thatNotExistingTopicCanNotBeRetrieved() {
    final var response =
        getTopic(
            UUID.randomUUID(), UUID.randomUUID(), HttpStatus.NOT_FOUND, ErrorDetailResponse.class);

    assertThat(response.primaryFault().get().faultCode())
        .isEqualTo(TOPIC_DOES_NOT_EXIST.toString());
  }

  @Test
  public void thatTopicCanNotBeRetrievedWithoutToken() {
    final var response =
        getTopicWithoutJwt(
            UUID.randomUUID(),
            UUID.randomUUID(),
            HttpStatus.UNAUTHORIZED,
            ErrorDetailResponse.class);

    assertThat(response.primaryFault().get().faultCode()).isEqualTo(UNAUTHORIZED.toString());
  }
}
