package sk.kosice.konto.kkmessageservice.business;

import static sk.kosice.konto.kkmessageservice.domain.permission.error.PermissionErrorCode.ACTION_IS_FORBIDDEN;
import static sk.kosice.konto.kkmessageservice.domain.permission.error.PermissionErrorCode.ACTOR_IS_EMPTY;

import java.util.Optional;
import java.util.UUID;
import sk.kosice.konto.kkmessageservice.business.permission.port.outbound.CheckPermissionsUseCase;
import sk.kosice.konto.kkmessageservice.domain.common.audit.ActorIdentity;
import sk.kosice.konto.kkmessageservice.domain.common.enumeration.Permission;
import sk.kosice.konto.kkmessageservice.domain.permission.command.ImmutableCheckPermissionCommand;

public abstract class AbstractService {

  public static final String SERVICE_NAME = "kkmessage-service";

  protected void checkPermission(
      CheckPermissionsUseCase checkPermissionsUseCase,
      Optional<ActorIdentity> actorIdentity,
      Permission permission,
      UUID actionOrganizationId) {
    if (actorIdentity.isEmpty()) {
      throw ACTOR_IS_EMPTY.createError().convertToException();
    }

    if (!checkPermissionsUseCase.execute(
        ImmutableCheckPermissionCommand.builder()
            .actorId(actorIdentity.get().id())
            .permissionToCheck(permission)
            .actionGroupId(actionOrganizationId)
            .build())) {
      throw ACTION_IS_FORBIDDEN
          .createError(permission.name(), actorIdentity.get().id())
          .convertToException();
    }
  }
}
