package sk.kosice.konto.kkmessageservice.business.message.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import sk.kosice.konto.kkmessageservice.business.AbstractService;
import sk.kosice.konto.kkmessageservice.business.message.port.inbound.ListMessageUseCase;
import sk.kosice.konto.kkmessageservice.business.message.port.outbound.QueryMessagePort;
import sk.kosice.konto.kkmessageservice.domain.message.entity.ListOfMessages;
import sk.kosice.konto.kkmessageservice.domain.message.query.MessageListingQuery;

@Named
public class ListMessageService extends AbstractService implements ListMessageUseCase {

  private final QueryMessagePort queryMessagePort;

  @Inject
  public ListMessageService(QueryMessagePort queryMessagePort) {
    this.queryMessagePort = queryMessagePort;
  }

  @Override
  public ListOfMessages execute(MessageListingQuery query) {
    return queryMessagePort.list(query);
  }
}
