package sk.kosice.konto.kkmessageservice.business.subscription.port.outbound;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import sk.kosice.konto.kkmessageservice.domain.subscription.data.DeleteSubscriptionsByOrganizationIdAndKidData;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.BaseSubscriptionEntity;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.SubscriptionEntity;

public interface PersistSubscriptionPort {

  void batchUpdate(List<BaseSubscriptionEntity> entities);

  void update(BaseSubscriptionEntity entities);

  void initSubscriptionsForRecipient(UUID recipientKid);

  void createNewSubscriptionForEachRecipient(UUID topicId);

  void insertSubscriptionsByOrganizationIdAndKid(UUID kid, Collection<UUID> organizationId);

  void batchDeleteByOrganizationIdAndKid(DeleteSubscriptionsByOrganizationIdAndKidData data);

  void batchDeleteByTopicId(UUID topicId);

  void insert(SubscriptionEntity entity);
}
