package sk.kosice.konto.kkmessageservice.business.topic.service;

import static sk.kosice.konto.kkmessageservice.domain.common.enumeration.Permission.ACTION_MANAGE_TOPIC;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import sk.kosice.konto.kkmessageservice.business.AbstractService;
import sk.kosice.konto.kkmessageservice.business.permission.port.outbound.CheckPermissionsUseCase;
import sk.kosice.konto.kkmessageservice.business.subscription.port.outbound.PersistSubscriptionPort;
import sk.kosice.konto.kkmessageservice.business.topic.port.inbound.DeleteTopicUseCase;
import sk.kosice.konto.kkmessageservice.business.topic.port.outbound.PersistTopicPort;
import sk.kosice.konto.kkmessageservice.business.topic.port.outbound.QueryTopicPort;
import sk.kosice.konto.kkmessageservice.domain.common.transactional.Transactional;
import sk.kosice.konto.kkmessageservice.domain.topic.command.DeleteTopicCommand;
import sk.kosice.konto.kkmessageservice.domain.topic.data.DeleteTopicData;
import sk.kosice.konto.kkmessageservice.domain.topic.data.ImmutableDeleteTopicData;
import sk.kosice.konto.kkmessageservice.domain.topic.query.FindTopicByIdQuery;

@Named
public class DeleteTopicService extends AbstractService implements DeleteTopicUseCase {

  private final PersistTopicPort persistTopicPort;
  private final QueryTopicPort queryTopicPort;
  private final PersistSubscriptionPort persistSubscriptionPort;
  private final Transactional transactional;
  private final CheckPermissionsUseCase checkPermissionsUseCase;

  @Inject
  public DeleteTopicService(
      PersistTopicPort persistTopicPort,
      QueryTopicPort queryTopicPort,
      PersistSubscriptionPort persistSubscriptionPort,
      Transactional transactional,
      CheckPermissionsUseCase checkPermissionsUseCase) {
    this.persistTopicPort = persistTopicPort;
    this.queryTopicPort = queryTopicPort;
    this.persistSubscriptionPort = persistSubscriptionPort;
    this.transactional = transactional;
    this.checkPermissionsUseCase = checkPermissionsUseCase;
  }

  @Override
  public void execute(DeleteTopicCommand command) {
    checkPermission(
        checkPermissionsUseCase, command.actorId(), ACTION_MANAGE_TOPIC, command.organizationId());

    final var entity =
        queryTopicPort.findOne(FindTopicByIdQuery.of(command.id(), command.organizationId()));

    transactional.result(
        () -> {
          persistSubscriptionPort.batchDeleteByTopicId(command.id());
          final DeleteTopicData data =
              ImmutableDeleteTopicData.builder()
                  .organizationId(entity.organizationId())
                  .id(entity.id())
                  .build();

          persistTopicPort.delete(data);
          return null;
        });
  }
}
