'use client';
import React, { useCallback, useState } from 'react';
import { CookieBannerActions } from './cookie-banner-actions';
import { CookieBannerNotification } from './cookie-banner-notification';
import { useCookies } from '@/hooks';

const CookieBanner: React.FC = () => {
  const { displayBanner, update } = useCookies();
  const [accepted, setAccepted] = useState(false);

  const acceptCookies = useCallback(() => {
    update({
      analytics: true,
      preferential: true
    });
    setAccepted(true);
  }, []);

  const declineCookies = useCallback(() => {
    update({
      analytics: false,
      preferential: false
    });
  }, []);

  const hideBanner = useCallback(() => {
    setAccepted(false);
  }, []);

  return (
    <>
      {(displayBanner || accepted) && (
        <div className="fixed top-0 left-0 w-full h-full bg-black-70 z-[999]">
          <div className="fixed bottom-0 left-0 w-full bg-white">
            <div className="max-w-6xl mx-auto pt-7 pb-5 px-4">
              {accepted ? (
                <CookieBannerNotification onHide={hideBanner} />
              ) : (
                <CookieBannerActions onAccept={acceptCookies} onDecline={declineCookies} settingsHref="/cookies" />
              )}
            </div>
          </div>
        </div>
      )}
    </>
  );
};

export default CookieBanner;
