import React from 'react';
import { SessionProvider } from 'next-auth/react';
import { AbstractIntlMessages, NextIntlClientProvider } from 'next-intl';
import NotificationsProvider from './Notifications';
import QueryProvider from './QueryProvider';
import EnvironmentProvider from './EnvironmentProvider';

interface ProvidersProps {
  messages: AbstractIntlMessages;
  session: any;
  children: React.ReactNode;
  environment: any;
}

const Providers: React.FC<ProvidersProps> = ({ messages, session, children, environment }) => (
  <NextIntlClientProvider messages={messages}>
    <EnvironmentProvider environment={environment}>
      <SessionProvider session={session}>
        <QueryProvider>
          <NotificationsProvider>{children}</NotificationsProvider>
        </QueryProvider>
      </SessionProvider>
    </EnvironmentProvider>
  </NextIntlClientProvider>
);

export default Providers;
