package sk.kosice.konto.kknotificationservice.restapi.dto.recipient;

import static io.swagger.v3.oas.annotations.media.Schema.RequiredMode.REQUIRED;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import org.immutables.value.Value;

@JsonDeserialize(as = ImmutableCreateOrUpdateRecipientRequest.class)
@JsonSerialize(as = ImmutableCreateOrUpdateRecipientRequest.class)
@Value.Immutable
public interface CreateOrUpdateRecipientRequest {

  @Schema(requiredMode = REQUIRED, example = "jozef.kosicky@icloud.com")
  @NotBlank
  @Size(min = 5, max = 255)
  @Email
  String getPreferredEmail();
}
