package sk.kosice.konto.kknotificationservice.scheduler;

import jakarta.inject.Inject;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import sk.kosice.konto.kknotificationservice.business.message.port.inbound.FindAndSendMessageWasNotSentUseCase;

public class SendEmailsJob {

  private static final Logger log = LoggerFactory.getLogger(SendEmailsJob.class);

  private final FindAndSendMessageWasNotSentUseCase findAndSendMessageWasNotSentUseCase;

  @Inject
  public SendEmailsJob(FindAndSendMessageWasNotSentUseCase findAndSendMessageWasNotSentUseCase) {
    this.findAndSendMessageWasNotSentUseCase = findAndSendMessageWasNotSentUseCase;
  }

  @Scheduled(
      initialDelay = 3000,
      fixedDelayString = "${sk.kosice.notification.scheduler.email-sender.frequency:3000}")
  @SchedulerLock(
      name = "sendEmails",
      lockAtMostFor = "${sk.kosice.notification.scheduler.email-sender.lock-at-most-for}")
  public void sendPendingEmails() {
    log.info("Sending not sent emails");

    findAndSendMessageWasNotSentUseCase.execute();

    log.debug("Sending not sent emails has finished.");
  }
}
