package sk.kosice.konto.kknotificationservice.domain.message.entity;

import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;
import org.immutables.value.Value;
import sk.kosice.konto.kknotificationservice.domain.common.marker.DomainEntity;

@Value.Immutable
@Value.Style(stagedBuilder = true)
public interface BaseMessageEntity extends DomainEntity {

  UUID id();

  String senderName();

  String title();

  Optional<String> tags();

  OffsetDateTime createdAt();

  UUID organizationId();

  static BaseMessageEntity of(MessageEntity entity) {
    return ImmutableBaseMessageEntity.builder()
        .id(entity.id())
        .senderName(entity.senderName())
        .title(entity.title())
        .createdAt(entity.createdAt())
        .organizationId(entity.organizationId())
        .tags(entity.tags())
        .build();
  }
}
