'use client';

import { Error, QueryHandler } from '@/components';
import { useOrganizations } from './use-organizations.hook';
import { OrganizationsListItem, OrganizationsListSkeleton } from '.';
import { Permission } from '@/utils';
import { useMemo } from 'react';

interface OrganizationsProps {
  items: Permission[];
  isActiveFn: (id: string) => boolean;
  changeFn: (item: Permission) => void;
}

const Organizations: React.FC<OrganizationsProps> = ({ items, isActiveFn, changeFn }) => {
  const data = useMemo(() => {
    const districts = [];
    const organizations = [];

    for (let i = 0; i < items.length; i++) {
      if (items[i].organization.isCityDistrict) {
        districts.push(items[i]);
      } else {
        organizations.push(items[i]);
      }
    }

    return { districts, organizations };
  }, [items]);

  return (
    <div className="flex flex-col gap-3 max-w-[28rem]">
      {!!data.districts.length && <h4>Mestské časti</h4>}
      {data.districts.map((item: Permission) => (
        <OrganizationsListItem
          key={item.organization.id}
          organization={item.organization}
          isActive={isActiveFn(item.organization.id)}
          onClick={() => changeFn(item)}
        />
      ))}
      {!!data.organizations.length && <h4 className="mt-4">Organizácie</h4>}
      {data.organizations.map((item: Permission) => (
        <OrganizationsListItem
          key={item.organization.id}
          organization={item.organization}
          isActive={isActiveFn(item.organization.id)}
          onClick={() => changeFn(item)}
        />
      ))}
    </div>
  );
};

const OrganizationsList = () => {
  const { query, isActive, change } = useOrganizations();

  return (
    <QueryHandler query={query} error={<Error err={query.error} />} loading={<OrganizationsListSkeleton />}>
      {(data) => <Organizations items={data.items} isActiveFn={isActive} changeFn={change} />}
    </QueryHandler>
  );
};

export default OrganizationsList;
