'use client';

import axios from 'axios';
import { api, Items, Permission, RequestError, unwrap } from '@/utils';
import { useQuery } from '@tanstack/react-query';
import { useSession } from 'next-auth/react';
import { useRouter } from 'next/navigation';

export const useOrganizations = () => {
  const { data, update } = useSession();
  const router = useRouter();

  const user = data?.user;

  const query = useQuery<Items<Permission>, RequestError>({
    queryKey: ['organizations'],
    queryFn: () => unwrap(axios.get(`/api${api.organizationsByOid(user?.oid || '')}`))
  });

  const change = async (permission: Permission) => {
    await update({ permission });
    router.push('/spravy');
  };

  const isActive = (organizationId: string) => {
    return user ? user.organization?.id === organizationId : false;
  };

  return { query, isActive, change, user };
};
