/**
 * HbbTV Player customization.
 *
 */

'use strict';

import Player from "mihbbtv/lib/hbbtv/player";
import Driver from "mihbbtv/lib/hbbtv/player/driver";
import Html5Driver from "mihbbtv/lib/hbbtv/player/html5Driver";

class HbbPlayer extends Player {

  /**
   * Enable GA.
   */
  enableGa() {
    // console.log(`enable GA`);
    const DELTA = Driver.DEVICE_UPDATE_PERIOD_MS / 1000;
    let lastPercent = 0;
    let lastPercentAccum = 0;
    let accum = 0;

    this.driver.removeEventCallback('enableGa');
    this.driver.addEventCallback('enableGa', this, (evnt) => {
      // if (Player.EVENT.PLAYING === evnt.type) {
      //   // starts or resuming playing
      //   // app.log('starts or resume');
      //   this.sendEvent('player_start', 'start');
      // } else
      if (Player.EVENT.STATUS === evnt.type) {
        // plying
        const int = Math.floor(evnt.currentTime);
        const INTERVAL = 1; // every 1sec
        const dur = this.driver._getMediaDuration();
        const percent = Math.floor(int / (dur / 100));
        const percentAccum = Math.floor(accum / (dur / 100));

        if (evnt.currentTime <= DELTA || (int % INTERVAL === 0 && (Math.abs(evnt.currentTime - int) < DELTA))) {
          // fire approximately every INTERVAL

          // truly listened seconds accumulated
          accum ++;
          // console.log(int, accum);

          // app.log('playing ' + 'playVideo ' + 'play[' + this.formatSeconds(int, true) + '] ' + (int % INTERVAL === 0) + ' ' + Math.abs(evnt.currentTime - int) + ' ' + evnt.currentTime /* + ' ' + Driver.DEVICE_UPDATE_PERIOD_MS*/);

          if (1 === accum) {
            this.sendEvent('player_start', 'start', percent, dur);
          } else if (10 === accum) {
            this.sendEvent('player_debounced', 'debounced', percent, dur);
          } else if (60 === accum) {
            this.sendEvent('player_stream', 'stream', percent, dur);
          }

          if (percentAccum > lastPercentAccum && percentAccum === 95) {
            this.sendEvent('player_finished', 'finished', percent, dur);

            if (dur < 10) {
              this.sendEvent('player_debounced', 'debounced', percent, dur);
            }

            if (dur < 60) {
              this.sendEvent('player_stream', 'stream', percent, dur);
            }
          }

          // percent change
          if (percent > lastPercent) {
            // console.log(`passed percent:`, percent, dur);

            if (percent > 0 && percent % 10 === 0) {
              this.sendEvent('player_progress_milestone', 'progress_milestone', percent, dur);
            }
          }

          lastPercent = percent;
          lastPercentAccum = percentAccum;
        }
      }
    });
  }

  sendEvent(evnt, action, percent = null, dur = null) {
    const item = (this.playlist[0] && this.playlist[0].opt) ? (this.playlist[0].opt) : {};
    const title = ((item.headline) ? item.headline : null);

    let query = {
      event: evnt,
      gaEventCategory: 'player',
      gaEventAction: action,
      contentID: item.id,
      contentShow: item.show,
      contentCreator: item.creator,
      // contentAudioEventCurrentTime: '0',
      contentAudioSource: 'prehravac hbbtv | ' + (('live' === item.type) ? 'live' : 'on-demand'),
   };

   if (percent) {
     query.contentAudioEventRelativeProgress = percent + '%';
   }
   if (dur) {
     query.contentLength = dur;
   }

   if (title) {
     query.gaEventLabel = title;
     query.contentName = title;
   }

   if ('live' === item.type) {
     query = {
       event: 'player_livestream_start',
       gaEventCategory: 'player',
       gaEventAction: 'livestream_start',
       contentCreator: item.creator,
       contentAudioSource: 'prehravac hbbtv | ' + (('live' === item.type) ? 'live' : 'on-demand'),
    };
   }

    if ('function' === typeof window.gtag) {
      window.gtag('event', query.event, query);
      // console.log(query, window.dataLayer);
    } else {
      // no GA initialized
      console.log('No GA to send,', query);
    }
  }

  getDriverClass() {
    let driverClass = null;

    if (Player.DRIVER_TYPES.AUTO === this.driverType) {
      const isHtml5Video = (!! document.createElement('video').canPlayType);

      const isSamsung = (navigator.userAgent.match(/samsung/i)) ? true : false;
      
      // console.log(`HTML5 video: ` + isHtml5Video + ' ' + isSamsung);

      driverClass = (isHtml5Video && ! isSamsung) ? Html5Driver : Driver;
    } else if (Player.DRIVER_TYPES.HTML5 === this.driverType) {
      driverClass = Html5Driver;
    } else {
      driverClass = Driver;
    }

    return driverClass;
  }

}

export default HbbPlayer;
