import ComponentAct from "mihbbtv/lib/hbbtv/application/act/component";
import FloatingPlayer from "../components/floatingPlayer";
import KeyHandler from "mihbbtv/lib/hbbtv/keyHandler";
import App from "mihbbtv/lib/hbbtv/application";

class ComponentActApp extends ComponentAct {

  keyHandlerButtons(kc) {

    const handlerResult = ComponentActApp.btnHandler(kc);
    if (handlerResult) {
      return handlerResult;
    }

    return super.keyHandlerButtons(kc);
	}

  static btnHandler(kc) {
    // inject global key handler for floating player
    const flPlayerResult = FloatingPlayer.getInstance().keyHandlerButtons(kc);
    if (flPlayerResult) {
      return flPlayerResult;
    }

    // override BACK button
    if (kc === KeyHandler.keycodes.VK_BACK || kc === KeyHandler.keycodes.VK_BACK_ALTER) {
      if (App.history) {
        const backResult = App.history.back();

        if (false === backResult) {
          App.exit(null, {toMenu: true});
        }
      }
      return true;
    }
  }

}

export default ComponentActApp;
