/**
 * Application main file with entering point (.onload()).
 *
 */
'use strict';

import App from "mihbbtv/lib/hbbtv/application";
import Broadcast from "mihbbtv/lib/hbbtv/broadcast";
import History from "mihbbtv/lib/hbbtv/application/history";

import FloatingPlayer from "./components/floatingPlayer";
import ScenesFactory from "./scenesFactory";
import config from "./config";
import classes from "./scenes"

import "../less/base.less";

App.setHistory(new History(config.history));

App.onLoad = (next) => {

  // enable bind on broadcast object just for SAMSUNG
  if (navigator && navigator.userAgent.match(/SAMSUNG/i)) {
    App.broadcast = new Broadcast();
    if (App.broadcast) {
      try {
        App.broadcast.init();
      } catch (e) {
        App.log(e);
      }
    }
  }

  const scenesFactory = new ScenesFactory();
  App.addScenes(scenesFactory.build(config.scenes, classes));

  FloatingPlayer.getInstance({container: 'floatingPlayer'}, App.elm).init();

	return next();
};

window.onload = App.dispatch(config);
