/**
 * Session Manager model.
 *
 */

'use strict';

import Storage from "mihbbtv/lib/hbbtv/storage";

class SessionManager {

  static getInstance() {
    if (! SessionManager.storage) {
      SessionManager.storage = new Storage('_hybahstr_cromr_');
    }

    return SessionManager.storage;
  }

  static initMenu(menu) {
    
    if (! (menu && menu.items && menu.items.length > 0)) {
      return false;
    }
    
    const session = SessionManager.getProfile();
    if (session) {
      // LOGIN

      const loginItem = menu.items.find((item) => 'login' === item.handle);
      
      if (loginItem) {
        loginItem.handle = 'profile';
        loginItem.title = 'můjPlaylist';
        menu.items.push({handle: 'logout', title: 'Odhlásit se', class: 'logout', icon: true, act: 1},);
        
        // console.log(menu);
        
        menu.elm.innerHTML = '';
        menu.init();
        
      }
    } else {
      // LOGOUT
      
      const logoutItemIndex = menu.items.findIndex((item) => 'logout' === item.handle);
      if (logoutItemIndex >= 0) {
        menu.items.splice(logoutItemIndex, 1);
      }
      
      const logoutItem = menu.items.find((item) => 'profile' === item.handle);
      if (logoutItem) {
        logoutItem.handle = 'login';
        logoutItem.title = 'Přihlásit se';
      }

      // console.log(menu);
      
      menu.elm.innerHTML = '';
      menu.init();
    }
  }

  static getProfile() {
    const storage = SessionManager.getInstance();

    try {
      const session = JSON.parse(storage.get('profile'));
      
      return session;
    } catch(e) {
      console.error(e);
    }

    return null;
  }

  static logIn(profile) {
    const storage = SessionManager.getInstance();

    storage.set('profile', JSON.stringify(profile));
  }

  static logOut() {
    const storage = SessionManager.getInstance();

    storage.del('profile');
  }

}

SessionManager.storage = null;

export default SessionManager;
