/**
 * Main scene.
 *
 * @author: Vaclav Hradec <vaclav@mihybrid.com>
 */
 'use strict';

import App from "mihbbtv/lib/hbbtv/application";
import Act from "mihbbtv/lib/hbbtv/application/act";
import KeyHandler from "mihbbtv/lib/hbbtv/keyHandler";

class MainAct extends Act {

  keyHandlerButtons(kc) {
    if (kc === KeyHandler.keycodes.VK_ENTER || kc === KeyHandler.keycodes.VK_BACK  || kc === KeyHandler.keycodes.VK_BACK_ALTER || kc === KeyHandler.keycodes.VK_BLUE) {
      if (App.history) {
        App.history.back();
      } else {
        App.setScene(this.parentScene.enteringScene);
      }
      return true;
    }

    if (kc === KeyHandler.keycodes.VK_RED) {
      App.exit(null, {toMenu: true});

      return true;
    }
  }
}

export default MainAct;
