/**
 * Carousel component.
 *
 * @author: Vaclav Hradec <vaclav@mihybrid.com>
 *
 * move directions [left, right, up, down]
 */

'use strict';

import Carousel from "mihbbtv/lib/components/carousel";
import Anim from "mihbbtv/lib/hbbtv/anim";
import Item from "../models/item";

class AppCarousel extends Carousel {

  itemMarkup(item) {
    const heading = `${item.heading ? `<h2>${item.heading}</h2>` : ''}`;

    return heading + Item.itemMarkup(item);
  }

  enterItem(item, app, scene) {
    return Item.enterItem(item, app, scene);
  }
}

export default AppCarousel;
