/**
 * Login component.
 *
 * @author: Vaclav Hradec <vaclav@mihybrid.com>
 *
 */

'use strict';

import App from "mihbbtv/lib/hbbtv/application";
import Login from "mihbbtv/lib/components/login";
import Image from "mihbbtv/lib/components/image";
import SessionManager from "../models/sessions";

import Api from "../api";

class AppLogin extends Login {

  load(data) {
    // console.log(data);

    this.data = data;

    //cleanup first
    this.init();

    let container = this.getContainer();

    container.innerHTML = this.itemMarkup(this.data);
  }

  checkStatus() {
    Api.loginStatus(this.data.statusUrl, (response) => {
      // console.log(`status`, response);

      if (! (response && response.status)) {
        return false;
      }

      this.stopStatus();
      return this.passAccess(response);
    });
  }

  stopStatus() {
    if (this.statusInterval) {
      clearInterval(this.statusInterval);
      this.statusInterval = null;
    }
  }

  startStatus() {
    this.stopStatus();

    this.statusInterval = setInterval(this.checkStatus.bind(this), AppLogin.STATUS_INTERVAL);
  }

  passAccess(data) {
    // console.log(`successful login`, data);
    SessionManager.logIn(data);
    SessionManager.initMenu(App.mainMenu);

    App.setScene('profile', null, data);
  }

  activate() {
    super.activate();

    this.startStatus();
  }

  deactivate() {
    super.deactivate();

    this.stopStatus();
  }

  itemMarkup(item) {
    return '<h2 id="' + this.container + 'TextHeading" class="heading">' +
        this.config.heading +
      '</h2>' +
      ((item.qrShow && item.qrImg) ?
        Image.markup({
          src: item.qrImg.replace('&', '&amp;'),
          class: 'qr',
          rounded: {
            tl: true,
            tr: true,
            bl: true,
            br: true,
          }
        }) : '') +
      '<div id="' + this.container + 'Text" class="text">' +
        '<h3 id="' + this.container + 'loginUrl" class="loginUrl">' +
        encodeURI(item.loginUrl) +
        '</h3>' +
        '<h3 id="' + this.container + 'sessionCode" class="sessionCode">' +
          item.loginSessionCode +
        '</h3>' +
      '</div>';
  }
}

AppLogin.STATUS_INTERVAL = 3000;    // 2secs

export default AppLogin;
