/**
 * SoloBanner component.
 *
 * @author: Vaclav Hradec <vaclav@mihybrid.com>
 *
 */

'use strict';

import Banner from "mihbbtv/lib/components/banner";
import Button from "mihbbtv/lib/components/button";
import Image from "mihbbtv/lib/components/image";
import Item from "../models/item";

class SoloBanner extends Banner {

  itemMarkup(item) {
    this.config.link = {
      id: item.id,
      type: item.type,
    };

    return '<div id="' + this.container + 'ImgShade" class="shade"></div>' +
    ((item.img) ? '<img id="' + this.container + 'ImgBgElm" class="bg" src="' + item.img + '" />' +
    Image.markup({
      src: item.img,
      rounded: {
        tl: true,
        tr: true,
        bl: true,
        br: true,
      }
    }) : '' ) +
    '<div id="' + this.container + 'Text" class="text">' +
      '<h2 id="' + this.container + 'TextTitle">' +
        item.title +
      '</h2>' +
      ((item.description) ? ('<p id="' + this.container + 'TextDescription">' + item.description + '</p>') : '') +
    '</div>' +
    Button.markup({
      id: this.container + 'Button',
      class: ((this.isActive) ? ' active' : ''),
      title: item.buttonTitle,
      rounded: {
        lft: true,
        rgt: true,
      }
    });
  }

  enterItem(app, scene) {
    return Item.enterItem(this.config.link, app, scene);
  }

}

export default SoloBanner;
