package sk.kosice.konto.kknotificationservice.repository.message;

import static sk.kosice.konto.kkmessageservice.repository.model.Tables.MESSAGE;
import static sk.kosice.konto.kkmessageservice.repository.model.Tables.RECIPIENT;
import static sk.kosice.konto.kknotificationservice.domain.message.error.MessageErrorCode.MESSAGE_DOES_NOT_EXIST;

import java.util.List;
import java.util.UUID;
import org.jooq.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import sk.kosice.konto.kknotificationservice.domain.message.entity.MessageEntity;
import sk.kosice.konto.kknotificationservice.repository.JooqRepository;
import sk.kosice.konto.kknotificationservice.repository.message.mapper.JooqMessageRepositoryMapper;

@Repository
public class JooqMessageRepository extends JooqRepository implements MessageRepositoryAdapter {

  @Autowired
  protected JooqMessageRepository(DSLContext dslContext) {
    super(dslContext);
  }

  @Override
  protected void createEntityDoesNotExistError(Object id) {
    throw MESSAGE_DOES_NOT_EXIST.createError(id).convertToException();
  }

  @Override
  public List<MessageEntity> findNotSentMessages(int limit) {

    return dslContext
        .select(MESSAGE)
        .from(MESSAGE)
        .leftOuterJoin(RECIPIENT)
        .on(RECIPIENT.KID.eq(MESSAGE.RECIPIENT_KID))
        .where(MESSAGE.IS_NOTIFICATION_SEND.eq(false))
        .and(
            (MESSAGE.RECIPIENT_KID.isNull().and(RECIPIENT.KID.isNull()))
                .or(MESSAGE.RECIPIENT_KID.isNotNull().and(RECIPIENT.KID.isNotNull())))
        .orderBy(MESSAGE.CREATED_AT.asc())
        .limit(limit)
        .fetch(r -> JooqMessageRepositoryMapper.messageRecordMapper().map(r.value1()));
  }

  @Override
  public void markMessageAsSent(UUID messageId) {
    dslContext
        .update(MESSAGE)
        .set(MESSAGE.IS_NOTIFICATION_SEND, true)
        .where(MESSAGE.ID.eq(messageId))
        .execute();
  }
}
