package sk.kosice.konto.kknotificationservice.business.recipient.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import sk.kosice.konto.kknotificationservice.business.AbstractService;
import sk.kosice.konto.kknotificationservice.business.permission.port.outbound.CheckPermissionsUseCase;
import sk.kosice.konto.kknotificationservice.business.recipient.port.inbound.FindRecipientByIdUseCase;
import sk.kosice.konto.kknotificationservice.business.recipient.port.outbound.QueryRecipientPort;
import sk.kosice.konto.kknotificationservice.domain.recipient.entity.RecipientEntity;
import sk.kosice.konto.kknotificationservice.domain.recipient.query.FindRecipientByIdQuery;
import sk.kosice.konto.kknotificationservice.domain.shared.enumeration.Permission;

@Named
public class FindRecipientByIdService extends AbstractService implements FindRecipientByIdUseCase {

  private final QueryRecipientPort queryRecipientPort;
  private final CheckPermissionsUseCase checkPermissionsUseCase;

  @Inject
  public FindRecipientByIdService(
      QueryRecipientPort queryRecipientPort, CheckPermissionsUseCase checkPermissionsUseCase) {
    this.queryRecipientPort = queryRecipientPort;
    this.checkPermissionsUseCase = checkPermissionsUseCase;
  }

  @Override
  public RecipientEntity execute(FindRecipientByIdQuery query) {
    checkPermission(checkPermissionsUseCase, query.actorId(), Permission.ACTION_MANAGE_RECIPIENT);
    return queryRecipientPort.findOne(query.kid());
  }
}
