'use client';

import { UseQueryResult } from '@tanstack/react-query';
import React, { useEffect, useState } from 'react';

interface QueryHandlerProps {
  error: React.ReactNode;
  loading: React.ReactNode;
  children: (data: any) => React.ReactNode;
  query: UseQueryResult<any, any>;
}

const QueryHandler: React.FC<QueryHandlerProps> = ({ query, error, loading, children }) => {
  const { status, data } = query;

  const [hasMounted, setHasMounted] = useState(false);

  useEffect(() => {
    setHasMounted(true);
  }, []);

  if (!hasMounted || status === 'pending') {
    return loading;
  }

  if (status === 'error') {
    return error;
  }

  return children(data);
};

export default QueryHandler;
