import { useTranslations } from 'next-intl';
import React from 'react';
import { CheckIcon, TextButton } from '@/lib/idsk';
import { TableList, TableListAction, TableListItem, TableListValue } from '@/components/core';
import { ContactType } from '@/utils';

interface ContactTableListProps {
  type: ContactType;
  data: string[];
  preferred: any;
  onRemove: (contact: string) => void;
  onSetPrimary: (contact: string) => void;
}

const ContactTableList: React.FC<ContactTableListProps> = ({ type, data, preferred, onRemove, onSetPrimary }) => {
  const t = useTranslations('my_data');
  return (
    <TableList>
      {data.map((item) => (
        <TableListItem key={item}>
          <TableListValue label={t(`contact_${type}`)}>
            <span className="break-all">{item}</span>
          </TableListValue>
          <TableListValue label={t(`contact_${type}_primary`)}>
            {preferred[type] === item ? <CheckIcon className="text-alert-positive" /> : '-'}
          </TableListValue>
          {preferred[type] !== item && (
            <>
              <TableListAction>
                <TextButton onClick={() => onSetPrimary(item)}>{t('contact_set_primary')}</TextButton>
              </TableListAction>
              <TableListAction>
                <TextButton variant="warning" onClick={() => onRemove(item)}>
                  {t('remove')}
                </TextButton>
              </TableListAction>
            </>
          )}
        </TableListItem>
      ))}
    </TableList>
  );
};

export default ContactTableList;
