'use client';

import React from 'react';
import { useTranslations } from 'next-intl';

interface MessageListPlaceholderProps {
  children: React.ReactNode;
}

const MessageListPlaceholder: React.FC<MessageListPlaceholderProps> = ({ children }) => {
  const t = useTranslations('messages');
  return (
    <div className="border border-neutral-300 rounded-lg overflow-hidden">
      <div className="idsk-data-grid__head hidden tb2:flex p-5 jutify-start">
        <div className="tb1:w-[16rem] mr-6">{t('sender')}</div>
        <div>{t('subject')}</div>
        <div className="ml-auto">{t('date')}</div>
      </div>
      <div className="idsk-data-grid__head block tb2:hidden">
        <div className="w-full">{`${t('sender')}/${t('subject')}/${t('date')}`}</div>
      </div>
      <div className="bg-white">{children}</div>
    </div>
  );
};

export default MessageListPlaceholder;
