import { useQuery } from '@tanstack/react-query';
import axios from 'axios';
import { api, Pets, RequestError } from '@/utils';
import { getRequestError } from '@/utils/api/error';

const QUERY_KEY = 'pets';

const getPets = async (kid: string, page: number, pageSize: number) => {
  try {
    const { data } = await axios.get(api.pets(kid), {
      params: {
        start: (page - 1) * pageSize,
        limit: pageSize
      }
    });
    return data;
  } catch (err) {
    throw getRequestError(err);
  }
};

const useGetPets = (kid: string, page: number, pageSize: number, options?: any) =>
  useQuery<Pets, RequestError>({
    queryKey: [QUERY_KEY, page, pageSize],
    queryFn: () => getPets(kid, page, pageSize),
    ...options
  });

export default useGetPets;
